$(document).ready(function(){
    $('.segment').click(function(){
        if(!window.adminLoggedIn){
            alert('Only admin can update booking status.');
            return;
        }

        var segment = $(this);
        var quarterDiv = segment.closest('.quarter');
        var floor = quarterDiv.data('floor');
        var quarter = quarterDiv.data('quarter');
        var br = segment.data('br');

        var colors = ['green', 'red', 'yellow'];
        var currentColor = segment.css('background-color');
        var currentStatus = colors.indexOf(currentColor);
        if(currentStatus === -1) currentStatus = 0;

        var nextStatus = (currentStatus + 1) % 3;

        $.post('update_status.php', {
            floor: floor,
            quarter: quarter,
            br: br,
            status: nextStatus
        }, function(response){
            if(response.success){
                segment.css('background-color', colors[nextStatus]);
            } else {
                alert('Update failed: ' + response.message);
            }
        }, 'json').fail(function(){
            alert('Error updating status');
        });
    });
});
