<?php
session_start();
$admin = isset($_SESSION['admin']) && $_SESSION['admin'] === true;

$db = new SQLite3('quarters.db');

$quarters = [];
$res = $db->query('SELECT * FROM quarters ORDER BY floor, quarter');
while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
    $quarters[] = $row;
}

function statusColor($status) {
    switch ($status) {
        case 0: return 'green';
        case 1: return 'red';
        case 2: return 'yellow';
        default: return 'grey';
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Quarters Booking</title>
    <link rel="stylesheet" href="style.css" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
<h1>Apartment Quarters Booking Status</h1>

<?php if (!$admin): ?>
<form method="post" action="login.php" id="loginBox">
    <label>Admin Password: <input type="password" name="password" /></label>
    <button type="submit">Login</button>
</form>
<?php else: ?>
<form method="post" action="logout.php" id="logoutBox">
    <button type="submit">Logout</button>
</form>
<?php endif; ?>

<div class="floors">
<?php
$currentFloor = 0;
foreach ($quarters as $q) {
    if ($q['floor'] !== $currentFloor) {
        if ($currentFloor !== 0) {
            echo "</div>";
        }
        $currentFloor = $q['floor'];
        echo "<h2>Floor {$currentFloor}</h2><div class='floor'>";
    }
    ?>
    <div class="quarter" data-floor="<?= $q['floor'] ?>" data-quarter="<?= $q['quarter'] ?>">
        <div class="br segment" data-br="1" style="background-color: <?= statusColor($q['br1_status']) ?>;">BR1</div>
        <div class="br segment" data-br="2" style="background-color: <?= statusColor($q['br2_status']) ?>;">BR2</div>
        <div class="quarter-label">Q<?= $q['quarter'] ?></div>
    </div>
    <?php
}
if ($currentFloor !== 0) {
    echo "</div>";
}
?>
</div>

<script>
  window.adminLoggedIn = <?= $admin ? 'true' : 'false' ?>;
</script>
<script src="script.js"></script>



</body>
</html>
