$(document).ready(function(){
    const colors = ['green', 'red', 'yellow'];

    // Initialize data-status attribute from background-color on page load
    $('.segment').each(function(){
        const bgColor = $(this).css('background-color');
        let status = 0;
        if (bgColor === 'rgb(0, 128, 0)') status = 0;      // green
        else if (bgColor === 'rgb(255, 0, 0)') status = 1; // red
        else if (bgColor === 'rgb(255, 255, 0)') status = 2; // yellow
        $(this).data('status', status);
    });

    $('.segment').click(function(){
        if(!window.adminLoggedIn){
            alert('Only admin can update booking status.');
            return;
        }

        var segment = $(this);
        var quarterDiv = segment.closest('.quarter');
        var floor = quarterDiv.data('floor');
        var quarter = quarterDiv.data('quarter');
        var br = segment.data('br');

        // Get current status from data attribute
        var currentStatus = segment.data('status') || 0;

        // Cycle to next status
        var nextStatus = (currentStatus + 1) % colors.length;

        $.post('update_status.php', {
            floor: floor,
            quarter: quarter,
            br: br,
            status: nextStatus
        }, function(response){
            if(response.success){
                // Update color and data-status
                segment.css('background-color', colors[nextStatus]);
                segment.data('status', nextStatus);
            } else {
                alert('Update failed: ' + response.message);
            }
        }, 'json').fail(function(){
            alert('Error updating status');
        });
    });
});

