<?php
$db = new SQLite3('quarters.db');

$db->exec('CREATE TABLE IF NOT EXISTS quarters (
    floor INTEGER,
    quarter INTEGER,
    br1_status INTEGER DEFAULT 0,
    br2_status INTEGER DEFAULT 0,
    PRIMARY KEY (floor, quarter)
)');

for ($f = 1; $f <= 12; $f++) {
    for ($q = 1; $q <= 4; $q++) {
        $exists = $db->prepare('SELECT 1 FROM quarters WHERE floor = :floor AND quarter = :quarter');
        $exists->bindValue(':floor', $f, SQLITE3_INTEGER);
        $exists->bindValue(':quarter', $q, SQLITE3_INTEGER);
        $res = $exists->execute()->fetchArray();
        if (!$res) {
            $insert = $db->prepare('INSERT INTO quarters (floor, quarter, br1_status, br2_status) VALUES (:floor, :quarter, 0, 0)');
            $insert->bindValue(':floor', $f, SQLITE3_INTEGER);
            $insert->bindValue(':quarter', $q, SQLITE3_INTEGER);
            $insert->execute();
        }
    }
}

echo "Database and table created with initial data.";
?>
