<?php
// status_summary.php
session_start();

try {
    $db = new SQLite3('quarters.db');

    $results = $db->query("SELECT * FROM quarters");

    $freeQuarters = 0;
    $occupiedQuarters = 0;
    $freeRooms = 0;
    $occupiedRooms = 0;

    while ($row = $results->fetchArray(SQLITE3_ASSOC)) {
        $br1 = isset($row['br1_status']) ? intval($row['br1_status']) : 0;
        $br2 = isset($row['br2_status']) ? intval($row['br2_status']) : 0;

        // Quarter is free if both segments are 0
        if ($br1 === 0 && $br2 === 0) {
            $freeQuarters++;
        }
        // Quarter is occupied if both segments are occupied
        elseif ($br1 !== 0 && $br2 !== 0) {
            $occupiedQuarters++;
        }

        // Individual BRs (rooms)
        $freeRooms += ($br1 === 0 ? 1 : 0);
        $freeRooms += ($br2 === 0 ? 1 : 0);

        $occupiedRooms += ($br1 !== 0 ? 1 : 0);
        $occupiedRooms += ($br2 !== 0 ? 1 : 0);
    }

    echo json_encode([
        'freeQuarters' => $freeQuarters,
        'occupiedQuarters' => $occupiedQuarters,
        'freeRooms' => $freeRooms,
        'occupiedRooms' => $occupiedRooms
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
?>

